/* ***************************************************** **
   ch08_pivoting_rows_to_columns.sql
   
   Skrypt dla książki Praktyczna nauka SQL dla Oracle, Helion (2022),
   napisanej przez Kima Berga Hansena, https://www.kibeha.dk
   Używasz na własną odpowiedzialność.
   *****************************************************
   
   Rozdział 8.
   Przestawianie rekordów na kolumny
   
   Skrypt przeznaczony do wykonania w schemacie PRACTICAL
** ***************************************************** */

/* -----------------------------------------------------
   Konfiguracja formatowania sqlcl
   ----------------------------------------------------- */

set pagesize 80
set linesize 80
set sqlformat ansiconsole
alter session set nls_date_format = 'YYYY-MM-DD';

/* -----------------------------------------------------
   Przykładowe fragmenty kodu do rozdziału 8.
   ----------------------------------------------------- */

-- Listing 8.2. Roczne zakupy piwa według browaru i grupy produktu

select
   brewery_name
 , group_name
 , extract(year from purchased) as yr
 , sum(qty) as qty
from purchases_with_dims pwd
group by 
   brewery_name
 , group_name
 , extract(year from purchased)
order by
   brewery_name
 , group_name
 , yr;

-- Listing 8.3. Konwersja rekordów lat na kolumny

select *
from (
   select
      brewery_name
    , group_name
    , extract(year from purchased) as yr
    , sum(qty) as qty
   from purchases_with_dims pwd
   group by 
      brewery_name
    , group_name
    , extract(year from purchased)
) pivot (
   sum(qty)
   for yr
   in (
      2016 as y2016
    , 2017 as y2017
    , 2018 as y2018
   )
)
order by brewery_name, group_name;

-- Listing 8.4. Wykorzystanie niejawnego grupowania

select *
from (
   select
      brewery_name
    , group_name
    , extract(year from purchased) as yr
    , qty
   from purchases_with_dims pwd
) pivot (
   sum(qty)
   for yr
   in (
      2016 as y2016
    , 2017 as y2017
    , 2018 as y2018
   )
)
order by brewery_name, group_name;

-- Listing 8.5. Ręczne przestawianie kolumn bez użycia klauzuli pivot

select
   brewery_name
 , group_name
 , sum(
      case extract(year from purchased)
         when 2016 then qty
      end
   ) as y2016
 , sum(
      case extract(year from purchased)
         when 2017 then qty
      end
   ) as y2017
 , sum(
      case extract(year from purchased)
         when 2018 then qty
      end
   ) as y2018
from purchases_with_dims pwd
group by 
   brewery_name
 , group_name
order by brewery_name, group_name;

-- Listing 8.6. Kod powodujący wygenerowanie błędu ORA-00918 w przypadku użycia wielu miar

select *
from (
   select
      brewery_name
    , group_name
    , extract(year from purchased) as yr
    , qty
    , cost
   from purchases_with_dims pwd
) pivot (
   sum(qty)
 , sum(cost)
   for yr
   in (
      2016 as y2016
    , 2017 as y2017
    , 2018 as y2018
   )
)
order by brewery_name, group_name;

-- Rozwiązaniem jest nadanie aliasów także kolumnom miar

select *
from (
   select
      brewery_name
    , group_name
    , extract(year from purchased) as yr
    , qty
    , cost
   from purchases_with_dims pwd
) pivot (
   sum(qty) as q
 , sum(cost) as c
   for yr
   in (
      2016 as "16"
    , 2017 as "17"
    , 2018 as "18"
   )
)
order by brewery_name, group_name;

-- Listing 8.7. Połączenie dwóch wymiarów i dwóch miar

select *
from (
   select
      brewery_name
    , group_name
    , extract(year from purchased) as yr
    , qty
    , cost
   from purchases_with_dims pwd
   where group_name in ('IPA', 'Wheat')
   and   purchased >= date '2017-01-01'
   and   purchased <  date '2019-01-01'
) pivot (
   sum(qty)  as q
 , sum(cost) as c
   for (group_name, yr)
   in (
      ('IPA'  , 2017) as i17
    , ('IPA'  , 2018) as i18
    , ('Wheat', 2017) as w17
    , ('Wheat', 2018) as w18
   )
)
order by brewery_name;

-- Te same wyniki otrzymane bez klauzuli where, choć to kiepski pomysł

select *
from (
   select
      brewery_name
    , group_name
    , extract(year from purchased) as yr
    , qty
    , cost
   from purchases_with_dims pwd
) pivot (
   sum(qty)  as q
 , sum(cost) as c
   for (group_name, yr)
   in (
      ('IPA'  , 2017) as i17
    , ('IPA'  , 2018) as i18
    , ('Wheat', 2017) as w17
    , ('Wheat', 2018) as w18
   )
)
order by brewery_name;

/* ***************************************************** */
